-- steps display; per-player
local Player = ...
assert(Player,"StepsDisplay needs Player")

local c
local displayFont = "_dejavu sans Bold 24px"

return Def.ActorFrame{
	InitCommand=function(self) c = self:GetChildren(); end;
	PlayerJoinedMessageCommand=function(self, params)
		if params.Player == Player then self:visible(true) end;
	end;
	PlayerUnjoinedMessageCommand=function(self, params)
		if params.Player == Player then self:visible(false) end;
	end;

	CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
	CurrentTrailP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;

	SetCommand=function(self)
		local diffText = "gtfo"
		local meterText = "0"
		local panelText = "[?]"
		local SongCourse, StepsTrail
		local diffColor = color("#FFFFFF")

		-- it's not done
		SongCourse = GAMESTATE:GetCurrentCourse()
		if SongCourse then
			StepsTrail = GAMESTATE:GetCurrentTrail(Player)
			if StepsTrail then
				diffText = GetCustomDifficulty(StepsTrail:GetStepsType(),StepsTrail:GetDifficulty(),SongCourse:GetCourseType())
				c.DifficultyName:diffuse(CustomDifficultyToColor(diffText))
				c.DifficultyName:shadowcolor( BoostColor(CustomDifficultyToColor(diffText),0.4) )

				meterText = StepsTrail:GetMeter()
				c.DifficultyMeter:diffuse(CustomDifficultyToColor(diffText))
				c.DifficultyMeter:shadowcolor( BoostColor(CustomDifficultyToColor(diffText),0.4) )

				local st = StepsTrail:GetStepsType()
				panelText = THEME:GetString("Panel",ToEnumShortString(st))
			else
				diffText = "no trail"
				meterText = "0"
			end
		else
			diffText = ""
			meterText = ""
			panelText = ""
		end


		c.DifficultyName:settext(diffText)
		c.DifficultyMeter:settext(meterText)
		c.Panels:settext(panelText)
	end;

	LoadFont(displayFont)..{
		Name="Panels";
		InitCommand=cmd(x,-40;halign,1;shadowlength,1;diffusebottomedge,color("#BBBBBB");zoom,10/24);
		OnCommand=cmd(diffusealpha,0;sleep,0.6;linear,0.15;diffusealpha,1);
	};
	LoadFont(displayFont)..{
		Name="DifficultyName";
		InitCommand=cmd(x,-38;halign,0;shadowlength,1;zoom,12/24;uppercase,true);
		OnCommand=cmd(diffusealpha,0;sleep,0.6;linear,0.15;diffusealpha,1);
	};
	LoadFont(displayFont)..{
		Name="DifficultyMeter";
		InitCommand=cmd(x,60;halign,1;shadowlength,1;zoom,12/24);
		OnCommand=cmd(diffusealpha,0;sleep,0.6;linear,0.15;diffusealpha,1);
	};
};